﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Device.Location;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web.Http;
using System.Web.Http.Description;
using System.Web.OData;
using System.Web.OData.Routing;
using BingMapsRESTToolkit;
using Microsoft.Web.Http;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;
using PpmsDataService.V1.Mappers;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using Newtonsoft.Json;
using System.Net.Http.Headers;
using System.Runtime.Serialization.Json;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.IO;
using System.Net.Http.Formatting;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;

namespace PpmsDataService
{
    /// <summary>
    /// Provides unbound, utility functions.
    /// </summary>
    [ApiVersionNeutral]
    public class GlobalFunctionsController : ODataController
    {    
        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(ProviderLocatorResult))]
        [ODataRoute("ProviderLocator")]
        public async Task<HttpResponseMessage> ProviderLocator([FromODataUri] string address, [FromODataUri] int radius, [FromODataUri] int driveTime, [FromODataUri] string specialtycode1, [FromODataUri] string specialtycode2, [FromODataUri] string specialtycode3, [FromODataUri] string specialtycode4, [FromODataUri] int network, [FromODataUri] int gender, [FromODataUri] int primarycare, [FromODataUri] int acceptingnewpatients, [FromODataUri] int maxResults)
        {
            //Default Values for maxResults
            if (maxResults > 625) { maxResults = 625; }

            var _service = await PpmsContextHelper.GetProxy();

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string key = ConfigurationManager.AppSettings["BingMapsKey"];

                //Geocode the Starting Address first
                var request = new GeocodeRequest()
                {
                    Query = address,
                    IncludeIso2 = true,
                    IncludeNeighborhood = true,
                    MaxResults = 25,
                    BingMapsKey = key
                };

                //Process the request by using the ServiceManager.
                var response = await ServiceManager.GetResponseAsync(request);

                if (response != null &&
                    response.ResourceSets != null &&
                    response.ResourceSets.Length > 0 &&
                    response.ResourceSets[0].Resources != null &&
                    response.ResourceSets[0].Resources.Length > 0)
                {
                    var result = response.ResourceSets[0].Resources[0] as Location;
                    if (result != null)
                    {
                        double startLatitude = result.Point.Coordinates[0];
                        double startLongitude = result.Point.Coordinates[1];
                        //var startingCoord = new Coordinate(startLatitude, startLongitude);
                        //var startingWayPoint = new SimpleWaypoint(startingCoord);
                        //var origin = new List<SimpleWaypoint> { startingWayPoint };

                        //Convert to Meters for formula.
                        double distanceCalc = radius * 1609.34;
                        /*
                        var northBoundCoord = DistanceCalc.getBounds(startLatitude, startLongitude, 0, distanceCalc);
                        decimal northBoundLat = (decimal)northBoundCoord.Latitude;
                        var eastBoundCoord = DistanceCalc.getBounds(startLatitude, startLongitude, 90, distanceCalc);
                        decimal eastBoundLong = (decimal)eastBoundCoord.Longitude;
                        var southBoundCoord = DistanceCalc.getBounds(startLatitude, startLongitude, 180, distanceCalc);
                        decimal southBoundLat = (decimal)southBoundCoord.Latitude;
                        var westBoundCoord = DistanceCalc.getBounds(startLatitude, startLongitude, 270, distanceCalc);
                        decimal westBoundLong = (decimal)westBoundCoord.Longitude;
                        */

                        //Only need the Northwest and Southeast coordinates to determine Bounds
                        var northWestBoundCoord = DistanceCalc.getBounds(startLatitude, startLongitude, 315, distanceCalc);
                        decimal northWestBoundLong = (decimal)northWestBoundCoord.Longitude;
                        decimal northWestBoundLat = (decimal)northWestBoundCoord.Latitude;

                        var southEastBoundCoord = DistanceCalc.getBounds(startLatitude, startLongitude, 135, distanceCalc);
                        decimal southEastBoundLong = (decimal)southEastBoundCoord.Longitude;
                        decimal southEastBoundLat = (decimal)southEastBoundCoord.Latitude;

                        //Build the FetchXml
                        string fetchXml = @"  
                        <fetch version='1.0' output-format='xml - platform' mapping='logical' distinct='true'> 
                        <entity name='ppms_providerservice'>
                        <attribute name='ppms_name'/>
                        <attribute name='ppms_caresiteaddress' />
                        <attribute name='ppms_caresitecity' />
                        <attribute name='ppms_caresitestateprovince' />
                        <attribute name='ppms_caresitezipcode' />
                        <attribute name='ppms_latitude' />
                        <attribute name='ppms_longitude' />
                        <attribute name='ppms_specialtynametext' />
                        <attribute name='ppms_providername' />
                        <attribute name='ppms_qualityrankingtotalscore' />
                        <attribute name='ppms_workhours' />
                        <attribute name='ppms_providerid' />
                        <attribute name='ppms_network' />
                        <attribute name='ppms_provideragreement' />
                        <attribute name='ppms_specialtycode' />
                        <attribute name='ppms_provideridentifer' />
                        <attribute name='ppms_caresite' />
                        <attribute name='ppms_providerserviceid' />
                        <order attribute='ppms_name' descending='false' />
                        <filter type='and'>
                        <condition attribute='statecode' operator='eq' value='0' />
                        <condition attribute='statuscode' operator='eq' value='1' />
                        <condition attribute='ppms_geocoded' operator='eq' value='1' />
                        <condition attribute='ppms_addressvalidated' operator = 'eq' value = '1' />
                        <condition attribute='ppms_latitude' operator='not-null' />
                        <condition attribute='ppms_longitude' operator='not-null' />";
                        fetchXml += "<condition attribute='ppms_latitude' operator='lt' value='" + northWestBoundLat + "'/>";
                        fetchXml += "<condition attribute='ppms_latitude' operator='gt' value='" + southEastBoundLat + "'/>";
                        fetchXml += "<condition attribute='ppms_longitude' operator='gt' value='" + northWestBoundLong + "'/>";
                        fetchXml += "<condition attribute='ppms_longitude' operator='lt' value='" + southEastBoundLong + "'/>";

                        //Provider Network
                        if (network != 0)
                        {
                            //To DO: Change this from a Linq Lookup
                            var providerNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == network);
                            if (providerNetwork != null) {
                                fetchXml += "<condition attribute='ppms_network' operator='eq' uiname='' uitype='ppms_vaprovidernetwork' value='{" + providerNetwork.Id + "}' />";
                            }
                        }

                        //Specialties
                        //If we have any specialites we'll add the OR Filter to Fetch
                        if (specialtycode1 != null || specialtycode2 != null || specialtycode3 != null || specialtycode4 != null)
                        {
                            fetchXml += "<filter type='or'>";
                            if (specialtycode1 != null) { fetchXml += "<condition attribute='ppms_specialtycode' operator='eq' value='" + specialtycode1 + "'/>"; }
                            if (specialtycode2 != null) { fetchXml += "<condition attribute='ppms_specialtycode' operator='eq' value='" + specialtycode2 + "'/>"; }
                            if (specialtycode3 != null) { fetchXml += "<condition attribute='ppms_specialtycode' operator='eq' value='" + specialtycode3 + "'/>"; }
                            if (specialtycode4 != null) { fetchXml += "<condition attribute='ppms_specialtycode' operator='eq' value='" + specialtycode4 + "'/>"; }
                            fetchXml += "</filter>";
                        }

                        //Gender
                        switch (gender)
                        {
                            case 0:
                                //Any gender
                                break;
                            case 1:
                                //Male
                                fetchXml += "<condition attribute='ppms_gender' operator='eq' value='767940002' />";
                                break;
                            case 2:
                                //Female
                                fetchXml += "<condition attribute='ppms_gender' operator='eq' value='767940001' />";
                                break;
                            default:
                                break;
                        }

                        switch (primarycare)
                        {
                            case 0:
                                //No Preference
                                break;
                            case 1:
                                fetchXml += "<condition attribute='ppms_primarycarephysician' operator='eq' value='1' />";
                                break;
                            case 2:
                                fetchXml += "<condition attribute='ppms_primarycarephysician' operator='eq' value='0' />";
                                break;
                            default:
                                break;
                        }

                        switch (acceptingnewpatients)
                        {
                            case 0:
                                //No Preference
                                break;
                            case 1:
                                fetchXml = "<condition attribute='ppms_individualisacceptingnewpatients' operator='eq' value='1' />";
                                fetchXml = "<condition attribute='ppms_primarycareprovideracceptingva' operator='eq' value='1' />";
                                break;
                            case 2:

                                break;
                            default:
                                break;
                        }
                        fetchXml += "</filter>";

                        //Check status of the related Provider, must be in Active State/Status Reason.
                        fetchXml += "<link-entity name='account' alias='am' to='ppms_providerid' from='accountid' ><filter type='and'>";
                        fetchXml += "<condition attribute='statecode' operator='eq' value='0' />";
                        fetchXml += "<condition attribute='statuscode' operator='eq' value='1' />";
                        fetchXml += "</filter></link-entity>";

                        //Check status of the Related Provider Agreement, must be in Active State/Status Reason
                        fetchXml += "<link-entity name='ppms_provideragreement' from='ppms_provideragreementid' to='ppms_provideragreement' visible='false' link-type='outer' alias='a_64728393f394e81181201458d04dc6b8'>";
                        fetchXml += "<attribute name='statecode'/>";
                        fetchXml += "<attribute name='statuscode'/>";
                        fetchXml += "</link-entity>";

                        fetchXml += "</entity></fetch> ";

                        //Retrieve Resutls using FetchXml above. 
                        EntityCollection results = _service.RetrieveMultiple(new FetchExpression(fetchXml));
                        //Initial List with Filters defined above. 

                        //Add Services to List with one additional fitler to check if there is either no Provider Agreement or the Provider Agreement is in Active Status.
                        var ppmsProviderServicesList = results.Entities.Where(x => x.Attributes.ContainsKey("a_64728393f394e81181201458d04dc6b8.statuscode") == false || ((OptionSetValue)x.GetAttributeValue<AliasedValue>("a_64728393f394e81181201458d04dc6b8.statuscode").Value).Value == 1).Select(e => e.ToEntity<ppms_providerservice>()).ToList();

                        /*
                        //Old Approach using LINQ
                         
                        var provServices = from ps in context.ppms_providerserviceSet
                                           where ps.StateCode.Value == (int)ppms_providerserviceState.Active
                                           where ps.StatusCode.Value == (int)ppms_providerservice_StatusCode.Active
                                           where ps.ppms_network != null
                                           where ps.ppms_ProviderId != null
                                           where ps.ppms_specialty != null
                                           where ps.ppms_latitude != null
                                           where ps.ppms_longitude != null
                                           where ps.ppms_latitude <= northBoundLat
                                           where ps.ppms_latitude >= southBoundLat
                                           where ps.ppms_longitude >= westBoundLong
                                           where ps.ppms_longitude <= eastBoundLong
                                           select ps;

                        //Add Optional Filters

                        //If any Specialty Codes are given, check for Provider Services with match Specialty Codes
                        if (specialtycode1 != null || specialtycode2 != null || specialtycode3 != null || specialtycode4 != null)
                            provServices = provServices.Where(ps => ps.ppms_specialtycode.Equals(specialtycode1) || ps.ppms_specialtycode.Equals(specialtycode2) || ps.ppms_specialtycode.Equals(specialtycode3) || ps.ppms_specialtycode.Equals(specialtycode4));

                        //Network Lookup
                        if (network != 0)
                        {
                            var providerNetwork = context.ppms_vaprovidernetworkSet.FirstOrDefault(i => i.ppms_networknumber == network);
                            if (providerNetwork != null)
                            {
                                provServices = provServices.Where(ps => ps.ppms_network.Id == providerNetwork.Id);
                            }
                        }
                                    
                        switch (gender)
                        {
                            case 0:
                                //Any gender
                                break;
                            case 1:
                                //Male
                                provServices = provServices.Where(ps => ps.ppms_providergender.Equals(ppms_Gender.Male));
                                break;
                            case 2:
                                //Female
                                provServices = provServices.Where(ps => ps.ppms_providergender.Equals(ppms_Gender.Female));
                                break;
                            default:
                                break;
                        }
                        

                        switch (primarycare)
                        {
                            case 0:
                                //No Preference
                                break;
                            case 1:
                                provServices = provServices.Where(ps => ps.ppms_providerisprimarycare.Equals(true));
                                break;
                            case 2:
                                provServices = provServices.Where(ps => ps.ppms_providerisprimarycare.Equals(false));
                                break;
                            default:
                                break;
                        }

                        switch (acceptingnewpatients)
                        {
                            case 0:
                                //No Preference
                                break;
                            case 1:
                                provServices = provServices.Where(ps => ps.ppms_provideracceptingnewpatients.Equals(true) && ps.ppms_provideracceptingva.Equals(true));
                                break;
                            case 2:
                                provServices = provServices.Where(ps => ps.ppms_provideracceptingnewpatients.Equals(false) && ps.ppms_provideracceptingva.Equals(false));
                                break;
                            default:
                                break;
                        }

                        //Initial List with Filters defined above. 
                        //var ppmsProviderServicesList = provServices.ToList();
                         */

                        //If there are more than 625 results inside the bounds sort down to the closest 625 inside Radius zone.
                        if (ppmsProviderServicesList.Count > 625)
                        {
                            var provServicesDistances = ppmsProviderServicesList
                                .Select(psr => new ProviderInRadius
                                {
                                    ProviderService = psr,
                                    Distance = DistanceCalc.GetDistance(startLatitude, startLongitude
                                 , Convert.ToDouble(psr.ppms_latitude), Convert.ToDouble(psr.ppms_longitude))
                                }).AsEnumerable();

                            //Add Providers to new list which meet the Radius criteria and Order by Distance. 
                            ppmsProviderServicesList = provServicesDistances.Where(psr => psr.Distance <= radius).OrderBy(psr => psr.Distance).Take(maxResults).Select(x => x.ProviderService).ToList();
                        }

                        if (ppmsProviderServicesList.Count > 0)
                        {
                            var provLocatorList = new List<ProviderLocatorResult>();
                            
                            //Split up into separate lists of max 625 for the Distance Matrix Request.
                            //If adding a Start time the max # in a request is 100
                            //var ppmsProviderServicesParsed = ppmsProviderServices.Select((x, i) => new { Index = i, Value = x }).GroupBy(x => x.Index / 100).Select(x => x.Select(v => v.Value).ToList()).ToList();
                            using (var client = new HttpClient())
                            {
                                var origins = new List<Models.DistanceMatrixRequest.Origin>();
                                var origin = new Models.DistanceMatrixRequest.Origin() { latitude = startLatitude, longitude = startLongitude };
                                origins.Add(origin);
                                var destinations = new List<Models.DistanceMatrixRequest.Destination>();
                                foreach (ppms_providerservice ppmsProviderService in ppmsProviderServicesList)
                                {
                                    double latitude = Convert.ToDouble(ppmsProviderService.ppms_latitude);
                                    double longitude = Convert.ToDouble(ppmsProviderService.ppms_longitude);
                                    var destination = new Models.DistanceMatrixRequest.Destination() { latitude = latitude, longitude = longitude };
                                    destinations.Add(destination);
                                }

                                //Create Request Content Objecet
                                var distanceMatrixRequestContent = new Models.DistanceMatrixRequest.RootObject()
                                {
                                    origins = origins,
                                    destinations = destinations,
                                    timeUnits = "minutes",
                                    travelMode = "driving",
                                    distanceUnits = "mile"                                 
                                };
                                //Can only optimize with traffic if total results is 10 or less. 
                                if(ppmsProviderServicesList.Count <= 10) { distanceMatrixRequestContent.StartTime = DateTime.Now.ToString(); }

                                //Serialize Content to Json
                                //var content = JsonConvert.SerializeObject(distanceMatrixRequestContent);
                                MediaTypeFormatter jsonFormatter = new JsonMediaTypeFormatter();
                                HttpContent httpContent = new ObjectContent<Models.DistanceMatrixRequest.RootObject>(distanceMatrixRequestContent, jsonFormatter);
                                var distanceMatrixPostUrl = String.Format("https://dev.virtualearth.net/REST/v1/Routes/DistanceMatrix?key={0}",key);
                                httpContent.Headers.ContentType.MediaType = ("application/json");
                                var matrixRequest = new HttpRequestMessage()
                                {
                                    RequestUri = new Uri(distanceMatrixPostUrl),
                                    Method = HttpMethod.Post,
                                    Content = httpContent
                                };
                                //matrixRequest.Headers.Add("Content-Type", "application/json");
                                HttpResponseMessage responseContent = client.SendAsync(matrixRequest).Result;

                                var json = responseContent.Content.ReadAsStringAsync().Result;

                                var matrixResponse = JsonConvert.DeserializeObject<Models.DistanceMatrixResponse.RootObject>(json);
                                if (matrixResponse != null &&
                                matrixResponse.resourceSets != null &&
                                matrixResponse.resourceSets.Count > 0 &&
                                matrixResponse.resourceSets[0].resources != null &&
                                matrixResponse.resourceSets[0].resources.Count > 0)
                                {
                                    var travelTimesDistances = matrixResponse.resourceSets[0].resources[0].results;

                                    for (var i = 0; i < travelTimesDistances.Count; i++)
                                    {
                                        
                                        //Only do mapping if the Provider Service falls within Radius & DriveTime
                                        if (travelTimesDistances[i].travelDistance <= radius && travelTimesDistances[i].travelDuration <= driveTime)
                                        {
                                            var provLocatorResult = new ProviderLocatorResult();
                                            provLocatorResult.Miles = travelTimesDistances[i].travelDistance;
                                            provLocatorResult.Minutes = travelTimesDistances[i].travelDuration;
                                            provLocatorResult.ProviderName = ppmsProviderServicesList[i].ppms_providername;
                                            provLocatorResult.ProviderSpecialty = ppmsProviderServicesList[i].ppms_specialtynametext;
                                            provLocatorResult.SpecialtyCode = ppmsProviderServicesList[i].ppms_specialtycode;
                                            provLocatorResult.ProviderIdentifier = ppmsProviderServicesList[i].ppms_provideridentifer;
                                            provLocatorResult.WorkHours = ppmsProviderServicesList[i].ppms_workhours;

                                            if (ppmsProviderServicesList[i].ppms_qualityrankingtotalscore != null)
                                            {
                                                provLocatorResult.QualityRanking = (int)ppmsProviderServicesList[i].ppms_qualityrankingtotalscore;
                                            }
                                            provLocatorResult.Latitude = Convert.ToDouble(ppmsProviderServicesList[i].ppms_latitude);
                                            provLocatorResult.Longitude = Convert.ToDouble(ppmsProviderServicesList[i].ppms_longitude);
                                            if (ppmsProviderServicesList[i].ppms_caresite != null)
                                            {
                                                provLocatorResult.CareSite =
                                                    ppmsProviderServicesList[i].ppms_caresite.Name;
                                                var careSite = context.ppms_caresiteSet.First(
                                                    c => c.Id == ppmsProviderServicesList[i].ppms_caresite.Id);
                                                provLocatorResult.CareSitePhoneNumber = careSite.ppms_mainsitephone;
                                            }

                                            provLocatorResult.CareSiteAddress = ppmsProviderServicesList[i].ppms_caresiteaddress + ' ' + ppmsProviderServicesList[i].ppms_caresitecity + ',' + ' ' +
                                                ppmsProviderServicesList[i].ppms_caresitestateprovince + ' ' + ppmsProviderServicesList[i].ppms_caresitezipcode;
                                            //Gender
                                            if (ppmsProviderServicesList[i].ppms_providergender != null)
                                                switch (ppmsProviderServicesList[i].ppms_providergender.Value)
                                                {
                                                    case (int)ppms_Gender.Male:
                                                        provLocatorResult.ProviderGender = ProviderGender.Male;
                                                        break;
                                                    case (int)ppms_Gender.Female:
                                                        provLocatorResult.ProviderGender = ProviderGender.Female;
                                                        break;
                                                    case (int)ppms_Gender.NotSpecified:
                                                        provLocatorResult.ProviderGender = ProviderGender.NotSpecified;
                                                        break;
                                                    case (int)ppms_Gender.Other:
                                                        provLocatorResult.ProviderGender = ProviderGender.Other;
                                                        break;
                                                }

                                            if (ppmsProviderServicesList[i].ppms_qualityrankingtotalscore != null)
                                                provLocatorResult.QualityRanking = (int)ppmsProviderServicesList[i].ppms_qualityrankingtotalscore;
                                            if (ppmsProviderServicesList[i].ppms_network != null)
                                            {
                                                provLocatorResult.ProviderNetwork = ppmsProviderServicesList[i].ppms_network.Name;
                                                var provNetwork = NetworkIds.GetNetwork(ppmsProviderServicesList[i].ppms_network.Id);
                                                provLocatorResult.NetworkId = provNetwork.Number;
                                            }
                                            if (ppmsProviderServicesList[i].ppms_providerisprimarycare != null)
                                                provLocatorResult.ProviderPrimaryCare = ppmsProviderServicesList[i].ppms_providerisprimarycare.Value;
                                            if (ppmsProviderServicesList[i].ppms_provideracceptingnewpatients != null)
                                                provLocatorResult.ProviderAcceptingNewPatients = ppmsProviderServicesList[i].ppms_provideracceptingnewpatients.Value;
                                            provLocatorList.Add(provLocatorResult);
                                        }
                                    }
                                }
                            }

                            //Sort the Results on Distance ascending.
                            provLocatorList.Sort((x, y) => x.Miles.CompareTo(y.Miles));
                            //Return the Results
                            return Request.CreateResponse(provLocatorList);

                        }
                        var message = string.Format("No Providers found based on Address, Radius and Filter Criteria given");
                        HttpError err = new HttpError(message);
                        return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
                    }
                }
                var geoCodeErrorMessage = string.Format("Unable to Geocode the given address");
                HttpError geoErr = new HttpError(geoCodeErrorMessage);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, geoErr);
            }
        }

        








        public static class DistanceCalc
        {
            public static bool IsInRadius(double lat1, double lon1, double lat2, double lon2, double radius)
            {
                var R = 6372.8; // In kilometers
                var dLat = toRadians(lat2 - lat1);
                var dLon = toRadians(lon2 - lon1);
                lat1 = toRadians(lat1);
                lat2 = toRadians(lat2);

                var a = Math.Sin(dLat / 2) * Math.Sin(dLat / 2) + Math.Sin(dLon / 2) * Math.Sin(dLon / 2) * Math.Cos(lat1) * Math.Cos(lat2);
                var c = 2 * Math.Asin(Math.Sqrt(a));
                var distance = R * 2 * Math.Asin(Math.Sqrt(a));
                if (distance <= radius)
                {
                    return true;
                }
                return false;
            }

            public static double GetDistance(double lat1, double lon1, double lat2, double lon2)
            {
                var R = 6372.8; // In kilometers
                var dLat = toRadians(lat2 - lat1);
                var dLon = toRadians(lon2 - lon1);
                lat1 = toRadians(lat1);
                lat2 = toRadians(lat2);
                var a = Math.Sin(dLat / 2) * Math.Sin(dLat / 2) + Math.Sin(dLon / 2) * Math.Sin(dLon / 2) * Math.Cos(lat1) * Math.Cos(lat2);
                var c = 2 * Math.Asin(Math.Sqrt(a));
                var distance = R * 2 * Math.Asin(Math.Sqrt(a));
                return distance;
            }

            public static ppms_providerservice ReturnInRadius(ppms_providerservice provService, double lat1, double lon1, int radius)
            {
                double lat2 = Convert.ToDouble(provService.ppms_latitude);
                double lon2 = Convert.ToDouble(provService.ppms_longitude);
                var R = 6372.8; // In kilometers
                var dLat = toRadians(lat2 - lat1);
                var dLon = toRadians(lon2 - lon1);
                lat1 = toRadians(lat1);
                lat2 = toRadians(lat2);

                var a = Math.Sin(dLat / 2) * Math.Sin(dLat / 2) + Math.Sin(dLon / 2) * Math.Sin(dLon / 2) * Math.Cos(lat1) * Math.Cos(lat2);
                var c = 2 * Math.Asin(Math.Sqrt(a));
                var distance = R * 2 * Math.Asin(Math.Sqrt(a));
                provService.ppms_distance = distance;
                if (distance <= radius)
                {
                    return provService;
                }
                return null;
            }

            public static double toRadians(double angle)
            {
                return Math.PI * angle / 180.0;
            }


            public static Coordinate getBounds(double lat1, double lon1, double brng, double dist)
            {
                var a = 6378137;
                var b = 6356752.3142;
                var f = 1 / 298.257223563; // WGS-84 ellipsiod
                var s = dist;
                var alpha1 = toRad(brng);
                var sinAlpha1 = Math.Sin(alpha1);
                var cosAlpha1 = Math.Cos(alpha1);
                var tanU1 = (1 - f) * Math.Tan(toRad(lat1));
                var cosU1 = 1 / Math.Sqrt((1 + tanU1 * tanU1));
                var sinU1 = tanU1 * cosU1;
                var sigma1 = Math.Atan2(tanU1, cosAlpha1);
                var sinAlpha = cosU1 * sinAlpha1;
                var cosSqAlpha = 1 - sinAlpha * sinAlpha;
                var uSq = cosSqAlpha * (a * a - b * b) / (b * b);
                var A = 1 + uSq / 16384 * (4096 + uSq * (-768 + uSq * (320 - 175 * uSq)));
                var B = uSq / 1024 * (256 + uSq * (-128 + uSq * (74 - 47 * uSq)));
                var sigma = s / (b * A);
                var sigmaP = 2 * Math.PI;
                double sinSigma = 0;
                double cosSigma = 0;
                double cos2SigmaM = 0;
                while (Math.Abs(sigma - sigmaP) > 1e-12)
                {
                    cos2SigmaM = Math.Cos(2 * sigma1 + sigma);
                    sinSigma = Math.Sin(sigma);
                    cosSigma = Math.Cos(sigma);
                    var deltaSigma = B * sinSigma * (cos2SigmaM + B / 4 * (cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM) - B / 6 * cos2SigmaM * (-3 + 4 * sinSigma * sinSigma) * (-3 + 4 * cos2SigmaM * cos2SigmaM)));
                    sigmaP = sigma;
                    sigma = s / (b * A) + deltaSigma;
                };
                var tmp = sinU1 * sinSigma - cosU1 * cosSigma * cosAlpha1;
                var lat2 = Math.Atan2(sinU1 * cosSigma + cosU1 * sinSigma * cosAlpha1, (1 - f) * Math.Sqrt(sinAlpha * sinAlpha + tmp * tmp));
                var lambda = Math.Atan2(sinSigma * sinAlpha1, cosU1 * cosSigma - sinU1 * sinSigma * cosAlpha1);
                var C = f / 16 * cosSqAlpha * (4 + f * (4 - 3 * cosSqAlpha));
                var L = lambda - (1 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM)));
                var revAz = Math.Atan2(sinAlpha, -tmp); // final bearing

                var latitude = toDeg(lat2);
                var longitude = lon1 + toDeg(L);
                return new Coordinate(latitude, longitude);
            }
            public static double toRad(double n)
            {
                return n * Math.PI / 180;
            }
            public static double toDeg(double n)
            {
                return n * 180 / Math.PI;
            }
        }

        public class ProviderInRadius
        {
            public ppms_providerservice ProviderService { get; set; }
            public double Distance { get; set; }
        }


        /*
        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(Coordinates))]
        [ODataRoute("Geocode")]
        public async Task<HttpResponseMessage> Geocode([FromODataUri] string address)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                string key = ConfigurationManager.AppSettings["BingMapsKey"];
                var request = new GeocodeRequest()
                {
                    Query = address,
                    IncludeIso2 = true,
                    IncludeNeighborhood = true,
                    MaxResults = 25,
                    BingMapsKey = key
                };

                //Process the request by using the ServiceManager.
                var response = await ServiceManager.GetResponseAsync(request);

                if (response != null &&
                    response.ResourceSets != null &&
                    response.ResourceSets.Length > 0 &&
                    response.ResourceSets[0].Resources != null &&
                    response.ResourceSets[0].Resources.Length > 0)
                {
                    var result = response.ResourceSets[0].Resources[0] as Location;
                    if (result != null)
                    {
                        double latitude = result.Point.Coordinates[0];
                        double longitude = result.Point.Coordinates[1];
                        var coordinate = new GeoCoordinate(latitude, longitude);


                        //Map the Lat, Long, and coordinate to Coordinates Class. 
                        var coordinates = new Coordinates();
                        coordinates.Latitude = latitude;
                        coordinates.Longitude = longitude;
                        coordinates.Coordinate = coordinate;

                        //Retrun the Coordinates
                        return Request.CreateResponse(coordinates);
                    }
                }

                var message = string.Format("Unable to Geocode the given address.");
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, err);
            }
        }

        [HttpGet]
        [MapToApiVersion("1.0")]
        [ResponseType(typeof(AddressData))]
        [ODataRoute("ValidateAddress")]      
        public async Task<HttpResponseMessage> ValidateAddress([FromODataUri] string streetAddress, [FromODataUri] string city, [FromODataUri] string state, [FromODataUri] string zip)
        {
            ServicePointManager.ServerCertificateValidationCallback += (sender, certificate, chain, sslPolicyErrors) => true;
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;
            try
            {
                //This Controller Action called the Address Validation API from Vets360
                using (var client = GetHttpClient())
                {
                    client.BaseAddress = new Uri("https://DNS.URL");
                    //client.BaseAddress = new Uri("https://DNS.URL");

                    var payload = new RootObjectRequest
                    {
                        requestAddress = new Models.Address
                        {
                            addressLine1 = streetAddress,
                            city = city,
                            stateProvince = new StateProvince
                            {
                                name = state
                            },
                            zipCode5 = zip
                        }
                    };

                    var json = Serializee(payload);

                    var content = new StringContent(json, Encoding.UTF8, "application/json");
                    content.Headers.ContentType = new MediaTypeHeaderValue("application/json");

                    var response = client.PostAsync("/address-validation/address/v1/validate", content).GetAwaiter().GetResult();

                    if (response.IsSuccessStatusCode)
                    {
                        var result = response.Content.ReadAsStringAsync().GetAwaiter().GetResult();
                        if (string.IsNullOrEmpty(result))
                        {
                            //
                        }
                        else
                        {
                            var addressValidationResult = Deserialize<RootObjectResponse>(result);
                            var addressData = await AddressDataMap.MapAddressData(addressValidationResult);
                            return Request.CreateResponse(addressData);
                        }
                    }
                    var addressValidationError = string.Format("Address Validation Unsuccessful: " + response.StatusCode.ToString());
                    HttpError addErr = new HttpError(addressValidationError);
                    return Request.CreateErrorResponse(HttpStatusCode.NotFound, addErr);

                }
            }
            catch (WebException we)
            {
                var addressValidationError = we.ToString();              
                HttpError addErr = new HttpError(addressValidationError);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, addErr);
             
            }
            catch (HttpRequestException he)
            {
                var addressValidationError = he.ToString();
                HttpError addErr = new HttpError(addressValidationError);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, addErr);
            }
            catch (Exception e)
            {
                var addressValidationError = e.ToString();               
                HttpError addErr = new HttpError(addressValidationError);
                return Request.CreateErrorResponse(HttpStatusCode.NotFound, addErr);
            }
            

        }
        */


        /*
        public static string Serializee<T>(T data)
        {
            var ms = new MemoryStream();
            var ser = new DataContractJsonSerializer(typeof(T));
            ser.WriteObject(ms, data);
            var json = ms.ToArray();
            ms.Close();

            return Encoding.UTF8.GetString(json, 0, json.Length);
        }

        public static T Deserialize<T>(string json)
        {
            var ms = new MemoryStream(Encoding.UTF8.GetBytes(json));
            var ser = new DataContractJsonSerializer(typeof(T));
            var result = (T)ser.ReadObject(ms);
            ms.Close();

            return result;
        }

        private static HttpClient GetHttpClient()
        {
            var clientHandler = new WebRequestHandler();
            clientHandler.ClientCertificates.Add(GetCertKeyVault());
            //clientHandler.ClientCertificates.Add(GetLocalCert());
            return new HttpClient(clientHandler);
        }

        public static X509Certificate2 GetLocalCert()
        {
            var store = new X509Store(StoreName.My, StoreLocation.LocalMachine);
            store.Open(OpenFlags.OpenExistingOnly | OpenFlags.ReadOnly);
            string certificateSubjectName = "CN=dws.DNS.URL, OU=PPMS, O=VA, L=Washington, S=DC, C=US";
            var cert = store.Certificates.Find(X509FindType.FindBySubjectDistinguishedName, certificateSubjectName, true);
            if (cert.Count < 1)
            {
                throw new Exception(string.Format("Could not find a valid client certificate with subject {0}", certificateSubjectName));
            }
            return cert[0];
        }

        private static X509Certificate2 GetCertKeyVault()
        {
            const string appId = "b39bbc92-24f7-4c26-961f-fae26b9290bb";
            const string secret = "wgnf5EwiMkDQG379L031MLpGmxli+1WHtSdqGuGXGMs=";
            const string tenantId = "f7c49e36-971b-42c7-b244-a88eed6c0bf6";
            //const string certUri = "https://vanpeastppmskv1.vault.usgovcloudapi.net/certificates/np-dws-ppms-va-gov-sslcert/716e28540d3e452d9ed47cf4053bb790";
            const string certUri = "https://vanpeastppmskv1.vault.usgovcloudapi.net/certificates/np-dws-ppms-nprod/ca92ba8988c64a6091d23c6adbdf1f1a";

            var token = GetToken(appId, secret, tenantId);
            var cert = GetCertificateFromKeyVault(token.access_token, certUri);
            var privateKey = GetPrivateKeyKeyVault(token.access_token, cert.sid);

            //return new X509Certificate2(privateKey, (string)null);
            return new X509Certificate2(privateKey, (string)null, X509KeyStorageFlags.MachineKeySet | X509KeyStorageFlags.PersistKeySet | X509KeyStorageFlags.Exportable);
        }


        private static TokenResponse GetToken(string clientId, string clientSecret, string tenantId)
        {
            using (var httpClient = new HttpClient())
            {
                var formContent = new FormUrlEncodedContent(new[]
                {
                    new KeyValuePair<string, string>("resource", "https://vault.usgovcloudapi.net"),
                    new KeyValuePair<string, string>("client_id", clientId),
                    new KeyValuePair<string, string>("client_secret", clientSecret),
                    new KeyValuePair<string, string>("grant_type", "client_credentials")
                });

                var response = httpClient.PostAsync("https://login.windows.net/" + tenantId + "/oauth2/token", formContent).GetAwaiter().GetResult();

                return Deserialize<TokenResponse>(response.Content.ReadAsStringAsync().Result);
            }
        }

        public static CertificateResponse GetCertificateFromKeyVault(string token, string certificateUrl)
        {
            using (var httpClient = new HttpClient())
            {
                var request = new HttpRequestMessage(HttpMethod.Get, new Uri(certificateUrl + "?api-version=2016-10-01"));
                request.Headers.Authorization = new AuthenticationHeaderValue("Bearer", token);

                var response = httpClient.SendAsync(request).GetAwaiter().GetResult();

                return Deserialize<CertificateResponse>(response.Content.ReadAsStringAsync().GetAwaiter().GetResult());
            }
        }

        public static byte[] GetPrivateKeyKeyVault(string token, string certificateUrl)
        {
            using (var httpClient = new HttpClient())
            {
                var request = new HttpRequestMessage(HttpMethod.Get, new Uri(certificateUrl + "?api-version=2016-10-01"));
                request.Headers.Authorization = new AuthenticationHeaderValue("Bearer", token);
                var response = httpClient.SendAsync(request).GetAwaiter().GetResult();
                var privateKey = Deserialize<PrivateKeyResponse>(response.Content.ReadAsStringAsync().GetAwaiter().GetResult());
                return Convert.FromBase64String(privateKey.value);
            }
        }


    }

    public class TokenResponse
    {
        public string token_type { get; set; }
        public string expires_in { get; set; }
        public string ext_expires_in { get; set; }
        public string expires_on { get; set; }
        public string not_before { get; set; }
        public string resource { get; set; }
        public string access_token { get; set; }
    }

    public class CertificateResponse
    {
        public string id { get; set; }
        public string kid { get; set; }
        public string sid { get; set; }
        public string x5t { get; set; }
        public string cer { get; set; }
    }

    public class PrivateKeyResponse
    {
        public string value { get; set; }
    }
    */




    }
}
